//
//  DHDArtNetUniverseConfig.h
//  DHDMX
//
//  Created by Douglas Heriot on 20/02/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "DHDArtNetPacketTypes.h"

@class DHDSockAddress;
@class DHDSockAddressIPv4;
@class DHDSockAddressIPv6;
@class DHDIPv4Config;
@class DHDNetworkInterface;

@interface DHDArtDMXIdentity : NSObject <NSCopying, NSCoding>
{
	NSData *_address;
	uint16_t _portAddress;
}

@property (readonly, nonatomic, copy) NSData *address;
@property (readonly, nonatomic) uint16_t portAddress;

@property (readonly, nonatomic) uint8_t universe;
@property (readonly, nonatomic) uint8_t subNet;
@property (readonly, nonatomic) uint8_t net;

// initWithAddress:portAddress: is the designated initialiser

- (id)init;
- (id)initWithPortAddress:(uint16_t)portAddress;
- (id)initWithAddress:(NSData *)address;
- (id)initWithAddress:(NSData *)address portAddress:(uint16_t)portAddress;

- (id)initWithUniverse:(uint8_t)universe subNet:(uint8_t)subNet net:(uint8_t)net;
- (id)initWithUniverse:(uint8_t)universe subNet:(uint8_t)subNet net:(uint8_t)net address:(NSData *)address;

+ (uint16_t)portAddressWithUniverse:(uint8_t)universe subNet:(uint8_t)subNet net:(uint8_t)net;
+ (void)getUniverse:(uint8_t *)universe subNet:(uint8_t *)subNet net:(uint8_t*)net fromPortAddress:(uint16_t)portAddress;

+ (DHDSockAddressIPv4 *)addressWithIPv4String:(NSString *)ip;
+ (DHDSockAddress *)addressWithAddress:(DHDSockAddress *)address; // ensures using correct Art-Net port
+ (DHDSockAddress *)addressWithNetworkInterface:(DHDNetworkInterface *)interface configIndex:(NSUInteger)configIndex; // picks broadcast IPv4 address, or loopback, if loopback. Pass 0 for configIndex if not know (in most cases, interfaces only have 1 IP assigned)
+ (DHDSockAddress *)addressWithIPv4Config:(DHDIPv4Config *)config;
+ (DHDSockAddressIPv4 *)defaultIPv4Address;

+ (in_port_t)port;

@end
